/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncFrame;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class FrameBlockEntity
extends CustomizableBlockEntity
implements ITickable {
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private final Option.IntOption chunkLoadingDistance = new Option.IntOption(() -> ((FrameBlockEntity)this).func_174877_v(), "chunkLoadingDistance", 16, 2, 32, 1);
    private List<Pair<GlobalPos, String>> cameraPositions = new ArrayList<Pair<GlobalPos, String>>();
    private GlobalPos currentCameraPosition;
    private GlobalPos newCameraPosition;
    private boolean activatedByRedstone = false;
    private boolean clientInteracted;
    private boolean switchCamera;

    public void func_73660_a() {
        if (this.activatedByRedstone) {
            boolean wasPowered = (Boolean)this.getBlockState().func_177229_b((IProperty)FrameBlock.POWERED);
            if (this.field_145850_b.field_72995_K && !wasPowered && this.clientInteracted) {
                this.switchCameraOnClient(this.currentCameraPosition, true);
            } else if (!this.field_145850_b.field_72995_K) {
                boolean hasNeighborSignal = this.field_145850_b.func_175640_z(this.field_174879_c);
                if (wasPowered && !hasNeighborSignal) {
                    this.disableCameraFeedOnServer(this.currentCameraPosition);
                }
                if (wasPowered != hasNeighborSignal) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)FrameBlock.POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal)));
                }
            }
        }
        if (this.switchCamera) {
            this.switchCamera = false;
            if (!this.field_145850_b.field_72995_K) {
                this.disableCameraFeedOnServer(this.newCameraPosition);
            } else {
                this.switchCameraOnClient(this.newCameraPosition, true);
            }
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.removeLinkWithCamera();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeLinkWithCamera();
    }

    private void removeLinkWithCamera() {
        if (this.currentCameraPosition != null) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.field_145850_b.func_175667_e(this.field_174879_c)) {
                    this.disableCameraFeedOnServer(this.currentCameraPosition);
                }
            } else if (this.clientInteracted) {
                this.switchCameraOnClient(this.currentCameraPosition, true);
                SecurityCraft.network.sendToServer((IMessage)new SyncFrame(this.field_174879_c, FrameFeedHandler.getFrameFeedViewDistance(this), Optional.empty(), Optional.ofNullable(this.currentCameraPosition), true));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("cameras")) {
            NBTTagList cameras = tag.func_150295_c("cameras", 10);
            this.cameraPositions.clear();
            for (int i = 0; i < cameras.func_74745_c(); ++i) {
                Pair cameraEntry;
                NBTTagCompound cameraTag = cameras.func_150305_b(i);
                if (cameraTag.func_82582_d()) {
                    cameraEntry = Pair.of(null, null);
                } else {
                    GlobalPos cameraPos = GlobalPos.load(cameraTag.func_74775_l("global_pos"));
                    String name = cameraTag.func_74764_b("name") ? cameraTag.func_74779_i("name") : null;
                    cameraEntry = Pair.of((Object)cameraPos, (Object)name);
                }
                this.cameraPositions.add((Pair<GlobalPos, String>)cameraEntry);
            }
        }
        GlobalPos newCameraPos = tag.func_74764_b("current_camera") ? GlobalPos.load(tag.func_74775_l("current_camera")) : null;
        if (this.currentCameraPosition == null && newCameraPos != null || this.currentCameraPosition != null && !this.currentCameraPosition.equals(newCameraPos)) {
            this.switchCamera = true;
            this.newCameraPosition = newCameraPos;
        }
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList camerasTag = new NBTTagList();
        for (Pair<GlobalPos, String> camera : this.cameraPositions) {
            NBTTagCompound cameraTag = new NBTTagCompound();
            if (camera != null) {
                GlobalPos pos = (GlobalPos)camera.getLeft();
                String name = (String)camera.getRight();
                if (pos != null) {
                    cameraTag.func_74782_a("global_pos", (NBTBase)pos.save());
                }
                if (name != null && !name.isEmpty()) {
                    cameraTag.func_74778_a("name", (String)camera.getRight());
                }
            }
            camerasTag.func_74742_a((NBTBase)cameraTag);
        }
        tag.func_74782_a("cameras", (NBTBase)camerasTag);
        if (this.currentCameraPosition != null) {
            tag.func_74782_a("current_camera", (NBTBase)this.currentCameraPosition.save());
        }
        return tag;
    }

    public boolean applyCameraPositions(ItemStack cameraMonitor) {
        List<Pair<GlobalPos, String>> newCameraPositions;
        if (!cameraMonitor.func_77942_o()) {
            cameraMonitor.func_77982_d(new NBTTagCompound());
        }
        if (!this.cameraPositions.equals(newCameraPositions = CameraMonitorItem.getCameraPositions(cameraMonitor.func_77978_p()))) {
            IBlockState state = this.getBlockState();
            this.cameraPositions = new ArrayList<Pair<GlobalPos, String>>(newCameraPositions);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return false;
    }

    public List<Pair<GlobalPos, String>> getCameraPositions() {
        return this.cameraPositions;
    }

    public void removeCameraOnClient(int camID) {
        GlobalPos cameraPos;
        Pair<GlobalPos, String> cameraEntry = this.cameraPositions.get(camID - 1);
        if (cameraEntry != null && (cameraPos = (GlobalPos)cameraEntry.getLeft()) != null) {
            this.removeCamera(cameraPos);
            if (cameraPos == this.currentCameraPosition) {
                FrameFeedHandler.removeFrameLink(this.currentCameraPosition, this);
                this.currentCameraPosition = null;
            }
            SecurityCraft.network.sendToServer((IMessage)new SyncFrame(this.func_174877_v(), FrameFeedHandler.getFrameFeedViewDistance(this), Optional.of(cameraPos), Optional.ofNullable(this.currentCameraPosition), false));
        }
    }

    public void removeCamera(GlobalPos cameraPos) {
        for (int i = 0; i < this.cameraPositions.size(); ++i) {
            Pair<GlobalPos, String> entry = this.cameraPositions.get(i);
            GlobalPos cameraListPos = (GlobalPos)entry.getLeft();
            if (cameraListPos == null || !cameraListPos.equals(cameraPos)) continue;
            this.cameraPositions.set(i, null);
            break;
        }
        if (this.cameraPositions.stream().allMatch(pair -> pair == null || pair.getLeft() == null)) {
            this.cameraPositions = new ArrayList<Pair<GlobalPos, String>>();
        }
        IBlockState state = this.getBlockState();
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void setCameraOnClientAndUpdate(GlobalPos camera) {
        this.switchCameraOnClient(camera, false);
        SecurityCraft.network.sendToServer((IMessage)new SyncFrame(this.field_174879_c, FrameFeedHandler.getFrameFeedViewDistance(this), Optional.empty(), Optional.ofNullable(this.currentCameraPosition), false));
    }

    public void disableCameraFeedOnServer(GlobalPos newCameraPos) {
        this.switchCameraOnServer(newCameraPos, null, 0, true);
    }

    public void unsetCurrentCameraOnServer() {
        this.switchCameraOnServer(null, null, 0, false);
    }

    public void switchCameraOnServer(GlobalPos newCameraPos, EntityPlayer player, int requestedRenderDistance, boolean disableNewCamera) {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity te;
            GlobalPos previousCameraPos = this.getCurrentCamera();
            this.setCurrentCamera(newCameraPos);
            if (previousCameraPos != null && (te = this.field_145850_b.func_175625_s(previousCameraPos.pos())) instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity previousCamera = (SecurityCameraBlockEntity)te;
                if (!previousCameraPos.equals(newCameraPos) || player == null && disableNewCamera) {
                    previousCamera.unlinkFrameForAllPlayers(this.field_174879_c);
                } else if (disableNewCamera) {
                    previousCamera.unlinkFrameForPlayer(player.func_110124_au(), this.field_174879_c);
                }
            }
            if (player instanceof EntityPlayerMP && !disableNewCamera && newCameraPos != null) {
                te = this.field_145850_b.func_175625_s(newCameraPos.pos());
                if (this.field_145850_b.field_73011_w.getDimension() != newCameraPos.dimension() || !(te instanceof SecurityCameraBlockEntity)) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", newCameraPos.pos()), TextFormatting.RED);
                } else {
                    SecurityCameraBlockEntity newCamera = (SecurityCameraBlockEntity)te;
                    if (!newCameraPos.equals(previousCameraPos) || !newCamera.isFrameLinked(player, this.field_174879_c)) {
                        if (this.redstoneSignalDisabled()) {
                            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.noRedstoneSignal", newCameraPos.pos()), TextFormatting.RED);
                        } else {
                            newCamera.linkFrameForPlayer((EntityPlayerMP)player, this.field_174879_c, MathHelper.func_76125_a((int)requestedRenderDistance, (int)2, (int)Math.min(this.getChunkLoadingDistanceOption(), Math.min(ConfigHandler.frameFeedViewDistance, ((EntityPlayerMP)player).field_71133_b.func_184103_al().func_72395_o()))));
                        }
                    }
                }
            }
            IBlockState state = this.getBlockState();
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void switchCameraOnClient(GlobalPos newCameraPos, boolean disableNewCamera) {
        if (this.field_145850_b.field_72995_K) {
            GlobalPos previousCameraPos = this.getCurrentCamera();
            this.setCurrentCamera(newCameraPos);
            if (previousCameraPos != null) {
                FrameFeedHandler.removeFrameLink(previousCameraPos, this);
            }
            if (newCameraPos != null && !disableNewCamera) {
                FrameFeedHandler.addFrameLink(this, newCameraPos);
                this.clientInteracted = true;
            } else if (disableNewCamera) {
                this.clientInteracted = false;
            }
        }
    }

    public boolean hasClientInteracted() {
        return this.clientInteracted;
    }

    public void setCurrentCamera(GlobalPos camera) {
        this.currentCameraPosition = camera;
        this.func_70296_d();
    }

    public GlobalPos getCurrentCamera() {
        return this.currentCameraPosition;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public int getChunkLoadingDistanceOption() {
        return (Integer)this.chunkLoadingDistance.get();
    }

    public boolean redstoneSignalDisabled() {
        return this.activatedByRedstone && (Boolean)this.getBlockState().func_177229_b((IProperty)FrameBlock.POWERED) == false;
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.chunkLoadingDistance};
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (!this.field_145850_b.field_72995_K && (option.getName().equals(this.disabled.getName()) && ((Boolean)this.disabled.get()).booleanValue() || option.getName().equals(this.chunkLoadingDistance.getName()))) {
            this.unsetCurrentCameraOnServer();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.activatedByRedstone = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)FrameBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            this.func_70296_d();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.ALLOWLIST) {
            this.unsetCurrentCameraOnServer();
        } else if (module == ModuleType.REDSTONE) {
            this.activatedByRedstone = false;
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)FrameBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            this.func_70296_d();
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE};
    }

    public IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }
}

